/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWSIMResourcesTableModel
extends AbstractTableModel
implements IVWSIMPropertyChangeListener {
    private static final int NUM_COLUMNS = 1;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_QUANTITY = 2;
    public static final int COL_COST = 3;
    public static final int COL_PERFORMANCE = 4;
    private static int m_nResourceNameCount = 0;
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_rowData = null;
    private int m_nType = 1;
    private int m_nQuantity = 1;
    private double m_cost = 1.0;
    private float m_performance = 1.0f;

    public VWSIMResourcesTableModel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_rowData = new Vector();
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void reinitialize() {
        int resourceCount;
        m_nResourceNameCount = 0;
        this.m_rowData.removeAllElements();
        Object[] resourceDefs = this.m_propertyData.getScenarioDefinition().getResources();
        if (resourceDefs != null && (resourceCount = resourceDefs.length) > 0) {
            try {
                VWQubbleSort qubbleSort = new VWQubbleSort();
                VWQubbleSort.sort(resourceDefs);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            for (int i = 0; i < resourceCount; ++i) {
                this.m_rowData.addElement(resourceDefs[i]);
            }
        }
        this.fireTableDataChanged();
    }

    public VWScenarioResourceDefinition getItemAt(int nRowIndex) {
        VWScenarioResourceDefinition resource = null;
        int rowDataCount = this.m_rowData.size();
        if (rowDataCount > 0 && nRowIndex >= 0 && nRowIndex < rowDataCount) {
            resource = (VWScenarioResourceDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return resource;
    }

    public void addItem() {
        VWScenarioResourceDefinition resourceDef = null;
        try {
            String name = null;
            boolean success = false;
            while (!success) {
                name = VWSIMResource.s_resource + ++m_nResourceNameCount;
                try {
                    resourceDef = this.m_propertyData.getScenarioDefinition().createResource(name, this.m_nType, this.m_nQuantity, this.m_cost, this.m_performance);
                    success = true;
                }
                catch (Exception ex) {}
            }
            this.m_propertyData.setDirty();
            this.m_rowData.addElement(resourceDef);
            this.m_nType = 1;
            this.m_nQuantity = 1;
            this.m_cost = 1.0;
            this.m_performance = 1.0f;
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 105, resourceDef);
            this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyItem(int nRowIndex) {
        try {
            VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
            if (resourceDef != null) {
                String name = VWSIMResource.s_copyOf + " " + resourceDef.getName();
                VWScenarioResourceDefinition newResourceDef = this.m_propertyData.getScenarioDefinition().createResource(name, resourceDef);
                this.m_rowData.addElement(newResourceDef);
                this.m_propertyData.setDirty();
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 105, resourceDef);
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
            if (resourceDef != null) {
                this.m_propertyData.deleteResourceAssignments(resourceDef);
                this.m_propertyData.getScenarioDefinition().deleteResource(resourceDef.getName());
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_propertyData.setDirty();
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 106, resourceDef.getName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Float.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        String resultString = null;
        switch (nColumnIndex) {
            case 0: {
                resultString = VWSIMResource.s_name;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (resourceDef != null) {
                        return resourceDef.getName();
                    }
                    return new String("");
                }
                case 1: {
                    if (resourceDef != null) {
                        return new Integer(resourceDef.getType());
                    }
                    return new Integer(this.m_nType);
                }
                case 2: {
                    if (resourceDef != null) {
                        return new Integer(resourceDef.getQuantity());
                    }
                    return new Integer(this.m_nQuantity);
                }
                case 3: {
                    if (resourceDef != null) {
                        return new Double(resourceDef.getCost());
                    }
                    return new Double(this.m_cost);
                }
                case 4: {
                    if (resourceDef != null) {
                        return new Float(1.0f / resourceDef.getPerformance() * 100.0f);
                    }
                    return new Float(1.0f / this.m_performance * 100.0f);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int column) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateType(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateQuantity(aValue, nRowIndex);
                break;
            }
            case 3: {
                this.onUpdateCost(aValue, nRowIndex);
                break;
            }
            case 4: {
                this.onUpdatePerformance(aValue, nRowIndex);
            }
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 107: {
                VWScenarioResourceDefinition resDef = (VWScenarioResourceDefinition)event.getParam();
                this.m_rowData.addElement(resDef);
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
                break;
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            VWScenarioResourceDefinition resourceDef;
            String name;
            if (aValue != null && aValue instanceof String && (name = (String)aValue).length() > 0 && (resourceDef = this.getItemAt(nRowIndex)) != null) {
                String oldName = resourceDef.getName();
                resourceDef.setName(name);
                this.m_propertyData.setDirty();
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 108, new String[]{oldName, name});
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    private void onUpdateType(Object aValue, int nRowIndex) {
        try {
            int nType = (Integer)aValue;
            VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
            if (resourceDef != null) {
                resourceDef.setType(nType);
                this.m_propertyData.setDirty();
            } else {
                this.m_nType = nType;
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    private void onUpdateQuantity(Object aValue, int nRowIndex) {
        try {
            int nQuantity = (Integer)aValue;
            VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
            if (resourceDef != null) {
                resourceDef.setQuantity(nQuantity);
                this.m_propertyData.setDirty();
            } else {
                this.m_nQuantity = nQuantity;
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    private void onUpdateCost(Object aValue, int nRowIndex) {
        try {
            double cost = (Double)aValue;
            VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
            if (resourceDef != null) {
                resourceDef.setCost(cost);
                this.m_propertyData.setDirty();
            } else {
                this.m_cost = cost;
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    private void onUpdatePerformance(Object aValue, int nRowIndex) {
        try {
            float performance = ((Float)aValue).floatValue();
            if ((double)performance > 0.0) {
                float ratio = 1.0f / (performance / 100.0f);
                VWScenarioResourceDefinition resourceDef = this.getItemAt(nRowIndex);
                if (resourceDef != null) {
                    resourceDef.setPerformance(ratio);
                    this.m_propertyData.setDirty();
                } else {
                    this.m_performance = ratio;
                }
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }
}

